<?php

extract( shortcode_atts( array(
	'title' => '',
	'id' => '',
	'input_style' => '',
	'input_shape' => '',
	'input_color' => '',
	'input_bg_color' => '',
	'button_style' => '',
	'button_color' => '',
	'button_align' => '',
	'button_shape' => '',
	'underline_text_color' => '',
), $atts ) );

$input_style = sm_validate_with_array( $input_style, sm_get_contact_form_input_styles_array() );
$input_shape = sm_validate_with_array( $input_shape, sm_get_contact_form_input_shapes_array() );
$button_style = sm_validate_with_array( $button_style, sm_get_contact_form_button_styles_array() );
$button_color = sm_validate_with_array( $button_color, sm_get_preset_colors_array( true, true, false ) );
$button_shape = sm_validate_with_array( $button_shape, sm_get_button_shapes_array() );

$GLOBALS['sm_contact_form7_input_style'] = $input_style;
$GLOBALS['sm_contact_form7_input_shape'] = $input_shape;
$GLOBALS['sm_contact_form7_button_style'] = $button_style;
$GLOBALS['sm_contact_form7_button_color'] = $button_color;
if ( $button_style != 'sm-style-underline' )
	$GLOBALS['sm_contact_form7_button_shape'] = $button_shape;

$params = array(
	'contact-form-7', 
	'title="' . $title . '"',
	'id="' . $id . '"',
);
$form_shortcode = '[' . implode( ' ', $params ) . ']';

$id = sm_shortcode_unique_id( "sm-contact-form" );
$css_gen = new Inline_CSS_Generator( "sm-contact-form", $id );
$scoped_css = '';

if ( !empty( $button_align ) ) {
	$align_array = array( 'width' => 'auto' );
	if ( 'sm-left' == $button_align ) $align_array['margin-right'] = 'auto !important';
	if ( 'sm-right' == $button_align ) $align_array['margin-left'] = 'auto !important';
	if ( 'sm-center' == $button_align ) {
		$align_array['margin-left'] = 'auto !important';
		$align_array['margin-right'] = 'auto !important';
	}
	$scoped_css .= $css_gen->css( 
		array( 
			'.wpcf7-form input[type=submit]',
			'.wpcf7-form button'
		),
		$align_array
	);
}

if ( !empty( $input_color ) ) {
	$scoped_css .= $css_gen->css( '.wpcf7-form input:not([type=submit])', array( 'color' => $input_color . ' !important' ) );
	$scoped_css .= $css_gen->css( '.wpcf7-form input::-webkit-input-placeholder', array( 'color' => $input_color . ' !important' ) );
	$scoped_css .= $css_gen->css( '.wpcf7-form input:-moz-placeholder', array( 'color' => $input_color . ' !important' ) );
	$scoped_css .= $css_gen->css( '.wpcf7-form input::-moz-placeholder', array( 'color' => $input_color . ' !important' ) );
	$scoped_css .= $css_gen->css( '.wpcf7-form input:-ms-input-placeholder', array( 'color' => $input_color . ' !important' ) );

	$scoped_css .= $css_gen->css( '.wpcf7-form textarea', array( 'color' => $input_color . ' !important' ) );
	$scoped_css .= $css_gen->css( '.wpcf7-form textarea::-webkit-input-placeholder', array( 'color' => $input_color . ' !important' ) );
	$scoped_css .= $css_gen->css( '.wpcf7-form textarea:-moz-placeholder', array( 'color' => $input_color . ' !important' ) );
	$scoped_css .= $css_gen->css( '.wpcf7-form textarea::-moz-placeholder', array( 'color' => $input_color . ' !important' ) );
	$scoped_css .= $css_gen->css( '.wpcf7-form textarea:-ms-input-placeholder', array( 'color' => $input_color . ' !important' ) );

	$scoped_css .= $css_gen->css( '.wpcf7-form .wpcf7-form-control-wrap:after', array( 'color' => $input_color . ' !important' ) );
	/*
	$scoped_css .= $css_gen->css( 
		array( '.wpcf7-list-item-label', 'div.wpcf7-validation-errors', 'div.wpcf7-mail-sent-ok' ),
		array( 'color' => $input_color . ' !important' ) );
	*/
	if ( 'sm-style-underline' == $input_style ) {
		$scoped_css .= $css_gen->css( 
			array(
				'.wpcf7-form input[type=text]',
				'.wpcf7-form input[type=email]',
				'.wpcf7-form input[type=url]',
				'.wpcf7-form input[type=tel]',
				'.wpcf7-form input[type=number]',
				'.wpcf7-form input[type=date]',
				'.wpcf7-form textarea',
			),
			array( 'border-bottom-color' => $input_color ) 
		);
		if ( !empty( $underline_text_color ) ) {
			$scoped_css .= $css_gen->css( 'button', array( 'color' => $underline_text_color . ' !important' ) );
		}
	}
}

if ( 'sm-style-solid' == $input_style && !empty( $input_bg_color ) ) {
	$scoped_css .= $css_gen->css( 
		array(
			'.wpcf7-form input[type=text]',
			'.wpcf7-form input[type=email]',
			'.wpcf7-form input[type=url]',
			'.wpcf7-form input[type=tel]',
			'.wpcf7-form input[type=number]',
			'.wpcf7-form input[type=date]',
			'.wpcf7-form textarea',
		),
		array( 'background-color' => $input_bg_color ) 
	);
}

$wrapper_attributes = array();
$wrapper_attributes[] = 'class="sm-contact-form"';
$wrapper_attributes[] = 'id="' . esc_attr( $id ) . '"';
?>
<div <?php echo implode( ' ', $wrapper_attributes ); ?>>
<?php
sm_the_scoped_css( $scoped_css );

add_filter( 'wpcf7_form_tag', 'sm_filter_contact_form_style', 10, 2 );
echo sm_js_remove_wpautop( $form_shortcode );
remove_filter( 'wpcf7_form_tag', 'sm_filter_contact_form_style', 10 );
?>
</div>